/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.questtypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.DimensionManager;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.global.GuiNPCManageQuest;
import noppes.npcs.client.gui.global.GuiQuestEdit;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcButtonYesNo;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.containers.ContainerNpcQuestTypeItem;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.quests.QuestObjective;
import noppes.npcs.util.CustomNPCsScheduler;

public class GuiNpcQuestTypeItem
extends GuiContainerNPCInterface
implements ITextfieldListener {
    private static final ResourceLocation back = new ResourceLocation("customnpcs", "textures/gui/smallbg.png");
    private static final ResourceLocation inv = new ResourceLocation("customnpcs", "textures/gui/baseinventory.png");
    private final QuestObjective task;
    private final Map<Integer, Integer> dataDimIDs = new HashMap<Integer, Integer>();

    public GuiNpcQuestTypeItem(EntityNPCInterface npc, ContainerNpcQuestTypeItem container, QuestObjective taskObj) {
        super(npc, (Container)container);
        this.setBackground("menubg.png");
        this.title = new TextComponentTranslation("quest.title.item", new Object[0]).func_150254_d();
        this.field_147000_g = 192;
        this.closeOnEsc = false;
        this.task = taskObj;
    }

    @Override
    public void func_146284_a(@Nonnull GuiButton guibutton) {
        if (!(guibutton instanceof GuiNpcButton)) {
            super.func_146284_a(guibutton);
            return;
        }
        if (this.task == null) {
            return;
        }
        GuiNpcButton button = (GuiNpcButton)guibutton;
        switch (button.field_146127_k) {
            case 0: {
                this.task.setItemLeave(button.getValue() == 0);
                break;
            }
            case 1: {
                this.task.setItemIgnoreDamage(((GuiNpcButtonYesNo)button).getBoolean());
                break;
            }
            case 2: {
                this.task.setItemIgnoreNBT(((GuiNpcButtonYesNo)button).getBoolean());
                break;
            }
            case 4: {
                if (!this.dataDimIDs.containsKey(button.getValue())) {
                    return;
                }
                this.task.dimensionID = this.dataDimIDs.get(button.getValue());
                button.setHoverText(new TextComponentTranslation("quest.hover.compass.dim", new Object[]{"" + this.task.dimensionID}).func_150257_a((ITextComponent)new TextComponentTranslation("quest.hover.compass", new Object[0])).func_150254_d(), new Object[0]);
                break;
            }
            case 5: {
                this.task.setPointOnMiniMap(((GuiNpcCheckBox)guibutton).isSelected());
                break;
            }
            case 10: {
                this.task.pos = new BlockPos(Math.floor(this.field_146297_k.field_71439_g.field_70165_t), Math.floor(this.field_146297_k.field_71439_g.field_70163_u), Math.floor(this.field_146297_k.field_71439_g.field_70161_v));
                this.task.dimensionID = this.field_146297_k.field_71439_g.field_70170_p.field_73011_w.getDimension();
                this.func_73866_w_();
                break;
            }
            case 11: {
                Client.sendData(EnumPacketServer.TeleportTo, this.task.dimensionID, this.task.pos.func_177958_n(), this.task.pos.func_177956_o(), this.task.pos.func_177952_p());
                break;
            }
            case 66: {
                this.task.setItem(this.field_147002_h.func_75139_a(0).func_75211_c());
                if (this.task.getItemStack().func_190926_b()) {
                    NoppesUtilServer.getEditingQuest((EntityPlayer)this.player).questInterface.removeTask(this.task);
                } else if (((GuiNPCManageQuest)GuiNPCManageQuest.Instance).subgui instanceof GuiQuestEdit) {
                    GuiQuestEdit subgui = (GuiQuestEdit)((GuiNPCManageQuest)GuiNPCManageQuest.Instance).subgui;
                    subgui.setSubGui(null);
                    subgui.func_73866_w_();
                }
                NoppesUtil.openGUI((EntityPlayer)this.player, GuiNPCManageQuest.Instance);
            }
        }
    }

    @Override
    protected void func_146976_a(float f, int i, int j) {
        this.func_146270_b(0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(back);
        int u = (this.field_146294_l - this.field_146999_f) / 2;
        int v = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(u, v, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(u, v += this.field_147000_g, 0, 196, this.field_146999_f, 26);
        this.field_146297_k.func_110434_K().func_110577_a(inv);
        u = 7 + (this.field_146294_l - this.field_146999_f) / 2;
        v = 91 + (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(u, v, 0, 0, 18, 18);
        u = 7 + (this.field_146294_l - this.field_146999_f) / 2;
        v = 112 + (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(u, v, 0, 0, 162, 76);
        super.func_146976_a(f, i, j);
    }

    protected void func_184098_a(@Nonnull Slot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
        CustomNPCsScheduler.runTack(this::func_73866_w_, 200);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int lId = 0;
        int x = this.field_147003_i + 6;
        int x1 = this.field_147003_i + this.field_146999_f - 55;
        int y = this.field_147009_r + 3;
        this.addLabel(new GuiNpcLabel(lId++, "quest.takeitems", x, y + 2));
        GuiNpcButton button = new GuiNpcButton(0, x1, y, 50, 14, new String[]{"gui.yes", "gui.no"}, this.task != null && this.task.isItemLeave() ? 0 : 1);
        button.setHoverText("quest.hover.edit.item.leave", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "gui.ignoreDamage", x, (y += 15) + 2));
        button = new GuiNpcButtonYesNo(1, x1, y, 50, 14, this.task == null || this.task.isIgnoreDamage());
        button.setHoverText("quest.hover.edit.item.ign.dam", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "gui.ignoreNBT", x, (y += 15) + 2));
        button = new GuiNpcButtonYesNo(2, x1, y, 50, 14, this.task == null || this.task.isItemIgnoreNBT());
        button.setHoverText("quest.hover.edit.item.ign.nbt", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(66, x, this.field_147009_r + this.field_147000_g, 40, 20, "gui.back");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "quest.itemamount", x, (y += 15) + 2));
        GuiNpcTextField textField = new GuiNpcTextField(0, (GuiScreen)this, this.field_146289_q, x1 + 1, y + 1, 48, 12, this.task != null ? this.task.getMaxProgress() + "" : "0");
        textField.setMinMaxDefault(0L, 576L, 1L);
        textField.setHoverText("quest.hover.edit.item.max", "576");
        this.addTextField(textField);
        TextComponentTranslation compass = new TextComponentTranslation("quest.hover.compass", new Object[0]);
        this.addLabel(new GuiNpcLabel(lId++, "X:", x, (y += 16) + 2));
        textField = new GuiNpcTextField(10, (GuiScreen)this, this.field_146289_q, x + 8, y, 40, 12, this.task != null ? "" + this.task.pos.func_177958_n() : "0");
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.task != null ? (long)this.task.pos.func_177958_n() : 0L);
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.pos", new Object[]{"X"}).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "Y:", x + 51, y + 2));
        textField = new GuiNpcTextField(11, (GuiScreen)this, this.field_146289_q, x + 58, y, 40, 12, this.task != null ? "" + this.task.pos.func_177956_o() : "0");
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.task != null ? (long)this.task.pos.func_177956_o() : 0L);
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.pos", new Object[]{"Y"}).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "Z:", x + 101, y + 2));
        textField = new GuiNpcTextField(12, (GuiScreen)this, this.field_146289_q, x + 109, y, 40, 12, this.task != null ? "" + this.task.pos.func_177952_p() : "0");
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.task != null ? (long)this.task.pos.func_177952_p() : 0L);
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.pos", new Object[]{"Z"}).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcButton(11, x + 151, y - 1, 14, 14, "TP");
        button.setHoverText("hover.teleport", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "R:", x, (y += 14) + 2));
        textField = new GuiNpcTextField(14, (GuiScreen)this, this.field_146289_q, x + 8, y, 25, 12, this.task != null ? "" + this.task.rangeCompass : "0");
        textField.setMinMaxDefault(0L, 64L, this.task != null ? (long)this.task.rangeCompass : 0L);
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.range", new Object[0]).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "N:", x + 36, y + 2));
        textField = new GuiNpcTextField(15, (GuiScreen)this, this.field_146289_q, x + 44, y, 120, 12, this.task != null ? this.task.entityName : "");
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.entity", new Object[0]).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "D:", x + 21, (y += 16) + 2));
        int p = 0;
        int i = 0;
        List<Integer> ids = Arrays.asList(DimensionManager.getStaticDimensionIDs());
        Collections.sort(ids);
        String[] dimIDs = new String[ids.size()];
        for (int id : ids) {
            dimIDs[i] = id + "";
            this.dataDimIDs.put(i, id);
            if (this.task != null && id == this.task.dimensionID) {
                p = i;
            }
            ++i;
        }
        button = new GuiNpcButton(4, x + 28, y - 1, 30, 16, dimIDs, p);
        button.setHoverText(new TextComponentTranslation("quest.hover.compass.dim", new Object[]{dimIDs[p]}).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId, "P:", x + 60, y + 2));
        int id = this.task == null ? -1 : this.task.regionID;
        textField = new GuiNpcTextField(9, (GuiScreen)this, this.field_146289_q, x + 67, y, 32, 14, "" + id);
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, id);
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.reg", new Object[]{id}).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcButton(10, x + 103, y - 1, 60, 16, "gui.set");
        button.setHoverText(new TextComponentTranslation("quest.hover.compass.set", new Object[0]).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcCheckBox(5, x + 42, this.field_147009_r + this.field_147000_g, 123, 16, "quest.set.minimap.point", null, this.task != null && this.task.isSetPointOnMiniMap());
        button.setHoverText("quest.hover.set.minimap.point", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (this.task == null) {
            return;
        }
        switch (textField.getID()) {
            case 0: {
                this.task.setMaxProgress(textField.getInteger());
                break;
            }
            case 9: {
                if (!BorderController.getInstance().regions.containsKey(textField.getInteger())) {
                    textField.setFullText("" + textField.getDefault());
                    return;
                }
                this.task.regionID = textField.getInteger();
                textField.setHoverText(new TextComponentTranslation("quest.hover.compass.reg", new Object[]{"" + this.task.regionID}).func_150257_a((ITextComponent)new TextComponentTranslation("quest.hover.compass", new Object[0])).func_150254_d(), new Object[0]);
                break;
            }
            case 10: {
                this.task.pos = new BlockPos(textField.getInteger(), this.task.pos.func_177956_o(), this.task.pos.func_177952_p());
                break;
            }
            case 11: {
                this.task.pos = new BlockPos(this.task.pos.func_177958_n(), textField.getInteger(), this.task.pos.func_177952_p());
                break;
            }
            case 12: {
                this.task.pos = new BlockPos(this.task.pos.func_177958_n(), this.task.pos.func_177956_o(), textField.getInteger());
                break;
            }
            case 14: {
                this.task.rangeCompass = textField.getInteger();
                break;
            }
            case 15: {
                this.task.entityName = textField.getFullText();
            }
        }
    }
}

